var moment = require('alloy/moment');

exports.definition = {
	config: {
        "columns": {
        	"id": "TEXT PRIMARY KEY",
            "loggedIn": "INTEGER",
            "loggedInSince": "TEXT",
            "accessToken": "TEXT",
            "refreshToken": "TEXT",
            "login": "TEXT",
            "email": "TEXT"
        },
        "defaults": {
        	"id": "user-info",
            "loggedIn": 0,
            "loggedInSince": "-",
            "accessToken": "-",
            "refreshToken": "-",
            "login": "-",
            "email": "-"
        },
        "adapter": {
            "type": "sql",
            "collection_name": "auth",
            "idAttribute": "id"
        }
    },
	extendModel : function(Model) {
        _.extend(Model.prototype, {
            login: function(username, password) {
            	Ti.API.info("--> login("+username+", "+password+")");
            	var that = this;
                var xhr = Ti.Network.createHTTPClient({
				    onload: function onLoad() {
            			Ti.API.info("login: token: success");
				    	var response = JSON.parse(xhr.responseText);
				    	var user = {
                        	loggedIn: 1,
                        	loggedInSince: moment().format('YYYY-MM-DD HH:mm:ss.SSS'),
                        	login: username,
                        	accessToken: response.access_token,
                        	refreshToken: response.refresh_token
                  		};
            			Ti.API.info("login: received access_token for '"+username+"':" + response.access_token);
                  		try {
            				Ti.API.info("login: calling the userinfo endpoint to retrieve details about the user...");
				    		var xhr2 = Ti.Network.createHTTPClient({
				    			onload: function onLoad() {
            						Ti.API.info("login: userinfo: success");
				    				var response2 = JSON.parse(xhr2.responseText);
				    				Ti.API.info("userinfo: " + xhr2.responseText);
				    				user.email = response2.email;
				    				user.login = response2.sub;
				    								    								    	
							        that.set(user);
			                    	that.save();
			                    	that.trigger("loginSucceeded", user);

		                  		},
							    onerror: function onError() {
            						Ti.API.info("login: userinfo: error: " + this.status + ": " + this.responseText);
							        
							        that.set(user);
			                    	that.save();
			                    	that.trigger("loginSucceeded", user);
				    			},
				    			validatesSecureCertificate: false
							});
				
							xhr2.open("GET", Alloy.CFG.oauth_userinfo_endpoint);
							var authstr = 'Bearer ' + user.accessToken;
							xhr2.setRequestHeader("Authorization", authstr);
							xhr2.send();
				
				    	} catch (e) {
				    		Ti.API.error("login: Userinfo call failed: " + e.message);
				    	}
				    },
				    onerror: function onError() {
            			Ti.API.info("login: token: error: " + this.status + ": " + this.responseText);
				        that.trigger("loginFailed");
				    },
				    validatesSecureCertificate: false
				});
				
				var body = "grant_type=password&username=" + encodeURIComponent(username) + "&password=" + encodeURIComponent(password) + "&client_id=" + encodeURIComponent(Alloy.CFG.oauth_client_id) + "&client_secret=" + encodeURIComponent(Alloy.CFG.oauth_client_secret) + "&scope=" + encodeURIComponent(Alloy.CFG.oauth_scope);
				body = body.replace(/%20/g, '+');
				
            	Ti.API.info("login: calling the token endpoint to get an access_token...");
				xhr.open("POST", Alloy.CFG.oauth_token_endpoint);
				xhr.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
				xhr.send(body);
            	Ti.API.info("<-- login()");
            },
            logout: function() {
            	Ti.API.info("--> logout()");
                this.set({
                    loggedIn: 0,
                    loggedInSince: '',
                    login: '',
                    email: '',
                    accessToken: '',
                    refreshToken: ''
                });
                this.save();
            	Ti.API.info("<-- logout()");
            },
            validateAuth: function() {
            	Ti.API.info("--> validateAuth()");
            	Ti.API.info("validateAuth: loggedIn = " + this.get('loggedIn') + ", login = " + this.get("login") + ", email = " + this.get("email"));
				
				if (this.get("loggedIn") == 0 || this.get("accessToken") == null || this.get("accessToken") == "") {
            		Ti.API.info("validateAuth: not logged in, triggering the 'loginNeeded' event !");
					this.trigger("loginNeeded");
					return;
				}
   
            	var that = this;
                var xhr = Ti.Network.createHTTPClient({
				    onload: function onLoad() {
            			Ti.API.info("validateAuth: userinfo: success: triggering the 'loggedIn' event !");
				    	that.trigger("loggedIn", that.toJSON());
				    },
				    onerror: function onError() {
            			Ti.API.info("validateAuth: userinfo: error: " + this.status + ": " + this.responseText);
				    	
				    	var xhr2 = Ti.Network.createHTTPClient({
				    		onload: function onLoad() {
            					Ti.API.info("validateAuth: token: success: ");
				    			var response2 = JSON.parse(xhr2.responseText);
				    			Ti.API.info("validateAuth: token: refresh response: " + xhr2.responseText);	    								    	
						        that.set({ accessToken: response2.access_token, refreshToken: response2.refresh_token });
		                    	that.save();
            					Ti.API.info("validateAuth: tokens refreshed successfully, triggering the 'loggedIn' event !");
		                    	that.trigger("loggedIn", that.toJSON());
	                  		},
						    onerror: function onError() {
            					Ti.API.info("validateAuth: token: error: " + this.status + ": " + this.responseText);
			            		Ti.API.info("validateAuth: refresh token not valid anymore, triggering the 'loginNeeded' event !");
		                    	that.trigger("loginNeeded");
			    			},
			    			validatesSecureCertificate: false
						});
           				Ti.API.info("validateAuth: calling the token endpoint to get a new access_token");
						var body = "grant_type=refresh_token&refresh_token=" + encodeURIComponent(that.get("refreshToken")) + "&client_id=" + encodeURIComponent(Alloy.CFG.oauth_client_id) + "&client_secret=" + encodeURIComponent(Alloy.CFG.oauth_client_secret);
						body = body.replace(/%20/g, '+');
						xhr2.open("POST", Alloy.CFG.oauth_token_endpoint);
						xhr2.send(body);
				    },
				    validatesSecureCertificate: false
				});
				
				
            	Ti.API.info("validateAuth: calling the userinfo endpoint to check if the current access_token is valid");
				xhr.open("GET", Alloy.CFG.oauth_userinfo_endpoint);
				var authstr = 'Bearer ' + this.get('accessToken');
				xhr.setRequestHeader("Authorization", authstr);
				xhr.send();
            	Ti.API.info("<-- validateAuth()");
            }
        });

        return Model;
    },
    extendCollection : function(Collection) {
        _.extend(Collection.prototype, {
            fetch: function(options) {
                options = options ? _.clone(options) : {};
                options.reset = true;
                return Backbone.Collection.prototype.fetch.call(this, options);
            },
        });
        return Collection;
    }
};